/*******************************************************************************
 * Copyright (c) Dino Octavian.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution, and is available at
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Contributors:
 *      Dino Octavian - initial API and implementation
 *******************************************************************************/
package gloodb.storage;

import gloodb.GlooException;

/**
 * Exception thrown when the storage is full and no objects can be added.
 * 
 */
public class StorageFullException extends GlooException {
	private static final long serialVersionUID = 6428223134342584145L;

	/**
	 * Default constructor.
	 */
	public StorageFullException() {
		super();
	}

	/**
	 * Creates an exception with message.
	 * 
	 * @param message
	 *            The exception message.
	 */
	public StorageFullException(String message) {
		super(message);
	}

	/**
	 * Creates a chained exception with message.
	 * 
	 * @param message
	 *            The exception message.
	 * @param cause
	 *            The cause of this exception.
	 */
	public StorageFullException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Creates a chained exception.
	 * 
	 * @param cause
	 *            The cause of this exception.
	 */
	public StorageFullException(Throwable cause) {
		super(cause);
	}

}
